state FireGnosisSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var fire_trap   									: W3FireGnosisTrap;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var fireball										: W3FireGnosisFireball;
	var boneRotation 									: EulerAngles;
	var bonePosition 									: Vector;
	var dummy											: CEntity;
	var dummy_proj                                      : W3FireGnosisDummy;
	var custom_anim										: name;
	var cast_hand										: CEntity;

	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("magic_sorceress.bnk") )
		{
			theSound.SoundLoadBank( "magic_sorceress.bnk", false );
		}
	
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		else if ( animEventName == 'cast_throw' )
		{
			cast_spells_gnosis();
			thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
		}
		else if ( animEventName == 'cast_end' )
		{
			cast_spells_axii_gnosis();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_gnosis()
	{
		switch( parent.spell_name )
		{
			case 'fire_gnosis_trap':
				{
					theGame.GetEntitiesByTag('fire_gnosis_trap_spells',ents_destroy);
					for( i=0; i<ents_destroy.Size(); i+=1 )
					{
						ents_destroy[i].AddTimer('destroy_fire_trap',0.0f);
					} 	
						
					if ( parent.actor && parent.actor.IsAlive() && parent.actor.IsOnGround() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false)  )
					{
						position = parent.actor.GetWorldPosition();
					}
					else
					{
						position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward()*3;
						position = find_position_spells( position );
					}
						
					rotation = thePlayer.GetWorldRotation();
					
					duration = 10;
					duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
					
					theGame.GetSurfacePostFX().AddSurfacePostFXGroup( TraceFloor( position ), 1.f, duration, 1.f, 4.f, 1);
						
					parent.templatename = "dlc\magicspellsrev\data\entities\fire_gnosis_trap.w2ent";
						
					fire_trap = (W3FireGnosisTrap)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), TraceFloor( position ), rotation );
					fire_trap.AddTimer('destroy_fire_trap', duration );
					fire_trap.AddTag('fire_gnosis_trap_spells');
					fire_trap.AddTag( 'spells_from_sign' );
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'fire_gnosis_stream':
				{
					parent.templatename = "dlc\magicspellsrev\data\entities\fire_gnosis.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), thePlayer.GetWorldPosition() );
					main_effect.PlayEffect('fire_gnosis_stream');
					main_effect.CreateAttachment( thePlayer, 'l_weapon');
					main_effect.AddTag('spells_alt_stream');
					
					parent.stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_cost_per_sec', false, true ) * 0.5 );
					parent.stamina_cost += parent.stamina_cost * get_stamina_cost_mult_streams(); 
					
					parent.stamina_delay = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_delay', false, true ) );
					parent.stamina_delay += parent.stamina_delay * get_stamina_delay_mult(); 
					
					parent.stream_hits.Clear();
					
					register_cancel_input_spells();
					
					cast_spells_stream_gnosis();
				}

				break;
			case 'fire_gnosis_cone':
				{
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = MatrixGetRotation(slotMatrix);
						
					castDir 		= MatrixGetAxisX( slotMatrix );
					castDir.Z 		= ClampF( castDir.Z, 0, 10 );
					targetPosition 	= position + ( 5 * castDir );
						
					parent.hand_aim_position = position;
					parent.hand_aim_direction = castDir;
						
					rotation.Roll = ClampF(rotation.Roll,-100,10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\fire_gnosis.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					main_effect.PlayEffect('fire_gnosis_cone');
					main_effect.DestroyAfter(10);
			
					dummy_proj = (W3FireGnosisDummy)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\fire_gnosis_dummy_projectile.w2ent",true ), position );
					dummy_proj.AddTag( 'spells_custom_projs' );
					dummy_proj.Init(NULL);
					dummy_proj.ShootProjectileAtPosition(0,	5, targetPosition, 10 );
					dummy_proj.DestroyAfter(10);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}
				
				break;
			default:		
				break;
		}
	}
	
	private function cast_spells_axii_gnosis()
	{
		var vector_attach 				: Vector;
	
		if ( parent.spell_name == 'fire_gnosis_fireball' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
				targetPosition = parent.actor.GetBoneWorldPosition( spells_get_pelvis_name( parent.actor ) );
				targetPosition.Z += 0.3;
			
				parent.templatename = "dlc\magicspellsrev\data\entities\fire_gnosis_fireball.w2ent";

				vector_attach = Vector( -0.2, 0.07, 0.05 );

				fireball = (W3FireGnosisFireball)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), thePlayer.GetWorldPosition() );
				fireball.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				fireball.AddTag( 'spells_custom_projs' );
				fireball.AddTag( 'spells_from_sign' );
				fireball.Init(NULL);
				fireball.PlayEffect( 'fire_fx' );
				fireball.BreakAttachment();
				fireball.ShootProjectileAtPosition(0, 20, targetPosition );
				fireball.DestroyAfter(10);

				effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'fire_gnosis_effects' ), thePlayer.GetWorldPosition() ) ;
				effect_entity.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				effect_entity.PlayEffect( 'fire_gnosis_shot' );
				effect_entity.DestroyAfter(3);
				
				Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
				thePlayer.SetCombatIdleStance( 1.f );
			}
		}
	}
	
	private entry function cast_spells_stream_gnosis()
	{
		var damage_action_stream				: W3DamageAction;
		var victims 							: array<CActor>;
		var victim								: CActor;
		var damage 								: float;
		var i									: int;
		var castDir								: Vector;
		var targetPosition						: Vector;
		var position							: Vector;
		var slotMatrix 							: Matrix;
		var effectentity						: CEntity;
		var coll, normal 						: Vector;
		var lastpos 							: Vector;
		var entities							: array<CGameplayEntity>;
		var lastpos2 							: Vector;
	
		while ( true )
		{
			if (  thePlayer.GetStatPercents( BCS_Stamina ) > 0.01f && thePlayer.GetBehaviorVariable	( 'IsCastingSign' ) == 1 )
			{
				thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
				position = MatrixGetTranslation(slotMatrix);
				
				castDir 		= MatrixGetAxisX( thePlayer.GetBoneWorldMatrixByIndex( thePlayer.GetBoneIndex( 'l_weapon' ) ) );
				targetPosition  = position + ( 6 * castDir );
				
				parent.hand_aim_position = position;
				parent.hand_aim_direction = castDir;
			
				FindGameplayEntitiesInCone( entities, position, VecHeading( castDir ), 25, 6, 100 );
			
				for (i=0; i<entities.Size(); i+=1)			
				{
					if ( !parent.stream_hits.Contains( entities[i] ) && !entities[i].HasTag('spells_custom_projs') )
					{
						entities[i].OnIgniHit( NULL );
						parent.stream_hits.PushBack( entities[i] );
					}
				}
				
				victims = thePlayer.GetNPCsAndPlayersInCone( 6, VecHeading( castDir ), 25, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
				for (i=0; i<victims.Size(); i+=1)	
				{
					victim = (CActor)victims[i];
					if ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive() )
					{
						damage = get_damage_value_for_stream( victim, GetMagicVigil().get_magic_spellpower() );
						damage *= theTimer.timeDelta;
					
						damage_action_stream = new W3DamageAction in this;
						damage_action_stream.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_SpellPower,false, false, true, false );
						damage_action_stream.SetProcessBuffsIfNoDamage(true);
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							damage *= 0.5;
						
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 3 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						else
						{
							if( RandF()<0.1 ) { damage_action_stream.AddEffectInfo( EET_Burning, 1 ); }
						}
						
						damage_action_stream.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage );
						damage_action_stream.SetIsDoTDamage( theTimer.timeDelta );
							
						damage_action_stream.SetHitAnimationPlayType(EAHA_ForceNo);
						damage_action_stream.SetHitEffect('');
						damage_action_stream.SetHitEffect('', true );
						damage_action_stream.SetHitEffect('', false, true);
						damage_action_stream.SetHitEffect('', true, true);
					
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action_stream.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action_stream );
						delete damage_action_stream;
					}
				}
				
				if( theGame.GetWorld().SweepTest( position + castDir, targetPosition, 0.3, coll, normal, parent.collisions_stream ) )
				{
					lastpos = coll;
					theGame.GetEntityByTag( 'spells_stream_collision' ).PlayEffectSingle('collision_fx');
					
					if ( VecDistance( lastpos2, coll ) > 0.3 )
					{
						lastpos2 = coll;
						theGame.GetSurfacePostFX().AddSurfacePostFXGroup( lastpos2, 0.3f, 8.0f, 1.0f, 4.0f, 1 );
					}
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).StopAllEffects();
				}
				
				if ( !theGame.GetEntityByTag( 'spells_stream_collision' ) )
				{
					effectentity = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\fire_gnosis_stream_collision.w2ent",true), targetPosition, thePlayer.GetWorldRotation() );
					effectentity.AddTag('spells_stream_collision');
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(lastpos);
				}
				
				GetWitcherPlayer().DrainStamina( ESAT_FixedValue, parent.stamina_cost * theTimer.timeDelta, parent.stamina_delay ); 
			}
			else
			{
				thePlayer.SoundEvent("gui_no_stamina");
				parent.PushState('Vigil_Dreaming');
			}
			
			Sleep( theTimer.timeDelta );
		}
	
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}